﻿Public Class utils

    Private Const RADS As Double = 180 / Math.PI ' Degrees in a radian (1 radian = 57.2958 degrees)
    Private Const DEGS As Double = Math.PI / 180 '  Radians in a degree (1 degree = 0.01745329252 radians)


    '-----------------------------------------------------------------------
    ' Convert degrrees to radians
    '-----------------------------------------------------------------------
    Public Function degreesToRads(ByVal pDegrees As Double) As Double
        Return (DEGS * pDegrees)
    End Function

    '-----------------------------------------------------------------------
    ' Convert radians to degrees
    '-----------------------------------------------------------------------
    Public Function radsToDegrees(ByVal pRads As Double) As Double
        Return (RADS * pRads)
    End Function


    ' -------------------------------------------------------------------------
    ' Converty a number to hours, mins, seconds
    ' -------------------------------------------------------------------------
    Public Sub decimalToHMS(ByVal pDec As Double,
                             ByRef pHr As Integer,
                             ByRef pMin As Integer,
                             ByRef pSec As Double)
        ' Arguments:  p_dec: Decimal value of time
        '             p_hr: Hours set by this function
        '             p_min: Minutes set by this function
        '             p_sec: Seconds set by this function
        Dim l_sn As Integer
        Dim l_xp As Double
        Dim l_a As Double


        l_sn = Math.Sign(pDec) ' sign returns -1 if < 0, 1 if > 0, 0 if 0
        l_xp = Math.Abs(pDec)

        pHr = Conversion.Int(l_xp)
        l_a = (l_xp - pHr) * 60
        pMin = Conversion.Int(l_a)
        pSec = Conversion.Int((l_a - pMin) * 6000.0) / 100.0
        pHr *= l_sn

    End Sub

    ' -------------------------------------------------------------------------
    ' Convert hours, mins and secs to a double
    ' -------------------------------------------------------------------------
    Public Function hmsToDecimal(ByVal pHr As Integer,
                              ByVal pMin As Integer,
                              ByVal pSec As Double) As Double
        Dim l_sn As Integer
        Dim lDec As Double

        If (pHr < 0 Or pMin < 0 Or pSec < 0) Then
            l_sn = -1
        Else
            l_sn = 1
        End If

        lDec = ((((Math.Abs(pSec) / 60) + Math.Abs(pMin)) / 60) + Math.Abs(pHr)) * l_sn

        Return (lDec)

    End Function

    ' -------------------------------------------------------------------------
    ' Normalise a number to between 0 and 24 (hours) and set an indicator if the
    ' original was the previous of next day
    ' -------------------------------------------------------------------------
    Public Sub normalise0to24withDay(ByRef pHr As Double, ByRef pNextPrevousDayIndicator As Double)

        pNextPrevousDayIndicator = 0 ' Same day

        While (pHr < 0)
            pHr += 24
            pNextPrevousDayIndicator = -1  ' Previous day
        End While

        While (pHr > 24)
            pHr -= 24
            pNextPrevousDayIndicator = 1 ' Next Day
        End While

    End Sub

    ' -------------------------------------------------------------------------
    ' Normalise a number to between 0 and 24 (hours)
    ' -------------------------------------------------------------------------
    Public Function normalise0to24(ByVal pVal As Double) As Double
        While (pVal > 24)
            pVal -= 24.0#
        End While

        While (pVal < 0)
            pVal += 24.0#
        End While

        Return (pVal)
    End Function

    ' -------------------------------------------------------------------------
    ' A simple error handler
    ' -------------------------------------------------------------------------
    Public Sub Err(ByVal pMsg As String, ByVal pFnName As String)
        Try

            MsgBox("Error in " & pFnName & vbCrLf & pMsg)

        Catch ex As Exception
            MsgBox(ex.Message)
        End Try
    End Sub

End Class
